using System.Collections.Generic;
using System.Linq;
using NUnit.Framework;
using Unity.Industrial.Forma.Core.AddressableSources;
using Unity.Industrial.Forma.Core.Building;
using Unity.Industrial.Forma.Core.Products;
using Unity.Industrial.Forma.Core.Publishing;
using Unity.Industrial.Forma.Editor.Build;
using UnityEditor;
using UnityEditor.AddressableAssets.Build.AnalyzeRules;
using UnityEditor.AddressableAssets.Settings;
using UnityEditor.Build.Reporting;
using UnityEngine;

namespace Unity.Industrial.Forma.SplitProductsByCatalogs
{
    public class SplitProducts : IFormaBuildCallbackReceiver
    {
        public int CallbackOrder => -1;

        public void OnPostAddressableDefaultDataCatalogBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, CatalogMetadata catalogMetadata) { }

        public void OnPreAddressableDefaultDataCatalogBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, ref CatalogMetadata catalogMetadata) { }

        public void OnPostAddressableProductCatalogBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, ExportableProductCatalog productCatalog, CatalogMetadata catalogMetadata) { }

        public void OnPreAddressableBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, ref List<AnalyzeRule> aaRulesToRun) { }

        public void OnPreAddressableProductCatalogBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, ref ExportableProductCatalog productCatalog, ref CatalogMetadata catalogMetadata) { }

        public void OnPreAddressableBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile, ref List aaRulesToRun) { }

        public void OnPreBuildProcess(BuildProfile buildProfile) { }

        public void OnPostBuildProcess(BuildProfile buildProfile, BuildReport buildReport) { }

        public void OnEarlyPreBuildProcess(BuildProfile buildProfile)
        {
            // Re-build the product list and move them into separate catalog to speed-up load time
            var newProductCatalogList = new List<ExportableProductCatalog>();
            var validProductList = buildProfile.ProductCatalogs.FirstOrDefault()?.ValidProductList;
            if (validProductList != null)
            {
                newProductCatalogList.AddRange(validProductList.Select(productToMove => new ExportableProductCatalog
                {
                    CatalogName = productToMove.name.ToDirectoryName(),
                    ProductList = new List<Product> { productToMove }
                }));
            }

            buildProfile.ProductCatalogs = newProductCatalogList;
            EditorUtility.SetDirty(buildProfile);
        }

        public void OnPostAddressableBuildProcess(AddressableAssetSettings settings, BuildProfile buildProfile)
        {
            // Revert product list changes
            var newProductCatalogList = new List<ExportableProductCatalog>
            {
                new ExportableProductCatalog
                {
                    CatalogName = "default",
                    ProductList = buildProfile.ProductCatalogs.SelectMany(p => p.ValidProductList).Distinct().ToList()
                }
            };
            buildProfile.ProductCatalogs = newProductCatalogList;
            EditorUtility.SetDirty(buildProfile);
        }
    }
}
